#ifndef __SIMMSGQUEUE_H__
#define __SIMMSGQUEUE_H__

class cEndpoint;
struct SimMsg;

//
// CAUTION: There is *no* locking on this class.

class cSimMsgQueue
{

 protected:

 public:

	//Constructor(s)
	cSimMsgQueue(unsigned int initialCap, unsigned int capInc);	

	//Destructor
	~cSimMsgQueue();

	//Public Functions
	bool	Clear();				// Clears the queue.
	int		GetNumElements()  { return mInsertPtr; }
	bool	Insert(SimMsg *msg);	// Inserts the msg into the queue.
	bool	Find(cEndpoint* ep, SimMsg* result);	// Finds a message for that endpoint if it exists.

 private:
	bool _Delete(unsigned int index);
	int	 _BinSearch(cEndpoint* ep, int left, int right);
	bool _Before(cEndpoint* a, cEndpoint* b);
	bool _Equal(cEndpoint* a, cEndpoint* b);
	bool _InsertSort();
	bool _Grow();		// Attempts to grow the view by at least one element, at most cap

	//Member Vars
	SimMsg*		  mQueue;
	unsigned int  mInsertPtr;
	unsigned int  mSize;
	unsigned int  mCapIncrement;
};

#endif
